/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.item;

import java.util.List;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.RemoteControlScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;

public class RemoteControl
extends class_1792
implements ItemGuiCreator {
    private static final String POSITION = "position";
    private static final String DIMENSION = "dimension";
    private static final Marker IT = MarkerManager.getMarker((String)RemoteControl.class.getSimpleName());

    public RemoteControl(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22431((Object)stack);
        }
        if (!DisplaysConfig.canInteractRemote(player)) {
            this.sendFatal(player, class_2561.method_43471((String)"waterframes.common.access.denied"));
            return class_1271.method_22431((Object)stack);
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_33133()) {
            this.sendFailed(player, class_2561.method_43471((String)"waterframes.remote.bound.failed"));
            return class_1271.method_22430((Object)stack);
        }
        if (player.method_18276() && !tag.method_33133()) {
            stack.method_7980(null);
            this.sendSuccess(player, class_2561.method_43471((String)"waterframes.remote.unbound.success"));
            return class_1271.method_22427((Object)stack);
        }
        int[] pos = this.getPosition(tag);
        String dim = this.getDimension(tag);
        if (pos.length < 3 || dim.isEmpty()) {
            this.sendFailed(player, class_2561.method_43471((String)"waterframes.remote.code.failed"));
            WaterFrames.LOGGER.error(IT, "NBT data is invalid, ensure your set pos as a long-int and the dimension as a resource location");
            return class_1271.method_22431((Object)stack);
        }
        class_2338 blockPos = new class_2338(pos[0], pos[1], pos[2]);
        class_2960 dimension = new class_2960(dim);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)class_25862;
            double distance = WaterFrames.getDistance(tile, (class_2374)player.method_19538());
            if (level.method_27983().method_29177().equals((Object)dimension) && distance < (double)DisplaysConfig.maxRcDis()) {
                GuiCreator.ITEM_OPENER.open(player.method_5998(hand).method_7948(), player, hand);
                return class_1271.method_22427((Object)stack);
            }
            this.sendFailed(player, class_2561.method_43471((String)"waterframes.remote.distance.failed"));
            return class_1271.method_22431((Object)stack);
        }
        player.method_5998(hand).method_7980(null);
        this.sendFailed(player, class_2561.method_43471((String)"waterframes.remote.display.failed"));
        return class_1271.method_22431((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        if (player == null || context.method_20287() == class_1268.field_5810 || !context.method_8041().method_7948().method_33133() || !player.method_18276()) {
            return class_1269.field_5811;
        }
        if (!DisplaysConfig.canBindRemote(player)) {
            this.sendFatal(player, class_2561.method_43471((String)"waterframes.common.access.denied"));
            return class_1269.field_5814;
        }
        if (level.method_8321(pos) instanceof DisplayTile) {
            class_1799 item = context.method_8041();
            class_2487 tag = item.method_7948();
            this.setPosition(tag, pos);
            this.setDimension(tag, level);
            this.sendSuccess(player, class_2561.method_43471((String)"waterframes.remote.bound.success"));
            return class_1269.field_5812;
        }
        this.sendFailed(player, class_2561.method_43471((String)"waterframes.remote.display.invalid"));
        return class_1269.field_5814;
    }

    private void sendSuccess(class_1657 player, class_5250 component) {
        if (player.field_6002.field_9236) {
            player.method_7353((class_2561)component.method_27692(class_124.field_1075), true);
            player.method_5783((class_3414)class_2766.field_12644.method_11886().comp_349(), 1.0f, 1.25f);
        }
    }

    private void sendFailed(class_1657 player, class_5250 component) {
        if (player.field_6002.field_9236) {
            player.method_7353((class_2561)component.method_27692(class_124.field_1061), true);
            player.method_5783((class_3414)class_2766.field_12648.method_11886().comp_349(), 1.0f, 0.75f);
        }
    }

    private void sendFatal(class_1657 player, class_5250 component) {
        if (player.field_6002.field_9236) {
            player.method_7353((class_2561)component.method_27692(class_124.field_1079), true);
            player.method_5783((class_3414)class_2766.field_12648.method_11886().comp_349(), 1.0f, 0.5f);
        }
    }

    public boolean hasPosition(class_2487 tag) {
        return tag.method_10545(POSITION);
    }

    public boolean hasDimension(class_2487 tag) {
        return tag.method_10545(DIMENSION);
    }

    public int[] getPosition(class_2487 tag) {
        return tag.method_10561(POSITION);
    }

    public String getDimension(class_2487 tag) {
        return tag.method_10558(DIMENSION);
    }

    public void setPosition(class_2487 tag, class_2338 pos) {
        tag.method_10539(POSITION, new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
    }

    public void setDimension(class_2487 tag, class_1937 level) {
        tag.method_10582(DIMENSION, level.method_27983().method_29177().toString());
    }

    public GuiLayer create(class_2487 tag, class_1657 player) {
        int[] pos = this.getPosition(tag);
        class_2338 blockPos = new class_2338(pos[0], pos[1], pos[2]);
        return new RemoteControlScreen(player, (DisplayTile)player.field_6002.method_8321(blockPos), tag, this);
    }

    public class_2561 getHighlightTip(class_1799 item, class_2561 displayName) {
        return class_2561.method_43470((String)displayName.getString()).method_27692(class_124.field_1075);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 isAdvanced) {
        class_315 opts = class_310.method_1551().field_1690;
        pTooltipComponents.add((class_2561)class_2561.method_43469((String)"waterframes.remote.description.1", (Object[])new Object[]{opts.field_1832.field_1655.method_27445(), opts.field_1904.field_1655.method_27445()}));
    }

    public boolean method_7886(class_1799 pStack) {
        class_2487 tag = pStack.method_7969();
        return tag != null && !tag.method_33133() && (tag.method_10545(POSITION) || tag.method_10545("pos")) && tag.method_10545(DIMENSION);
    }

    public boolean method_7885(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer) {
        return false;
    }
}

